'use client';
import { useLocale } from 'next-intl';
import { motion, Transition } from "motion/react"

interface LocalizedText {
  ar: string;
  en: string;
}

interface PageMain {
  id: number;
  title: LocalizedText;
  description: LocalizedText;
  cover: string | null;
}
export default function HeaderSection(props: PageMain) {
  const { id, title, description, cover } = props;
  const locale = useLocale() as 'ar' | 'en';

  const springTransition: Transition = {
    duration: 0.6,
    delay: 0.3,
    ease: [0, 0.71, 0.2, 1.01],
  };

  return (
    <motion.div
      key={id}
      className="container flex flex-col md:flex-row justify-center items-center gap-5 py-10 px-4 md:px-0"
      initial={{ opacity: 0, y: 10 }}
      whileInView={{ opacity: 1, y: 0 }}
      viewport={{ once: false, amount: 0.2 }}
      transition={springTransition}
    >
      <div className="flex order-2 md:order-1 flex-col gap-8 w-full items-start content-start align-middle">
        <div className="text-main-orange text-[30px] font-bold font-main">
          {title[locale]}
        </div>
        <div
          className="text-start text-[16px] text-gray-500 font-almarai leading-relaxed"
          dangerouslySetInnerHTML={{ __html: description[locale] }}
        />
      </div>
      {
        cover!=null ? <>
          <div className="flex order-1 md:order-2 w-full items-center content-center align-middle">
            <img
              title={title[locale]}
              alt={title[locale]}
              src={cover}
              className={`h-auto m-auto max-w-full w-115.5`}
            />
          </div>
        </>:<></>
      }
    </motion.div>
  )
}